/** @file   CreditsViewer.cpp
 * @brief   Implementation of CreditsViewer class.
 * @version $Revision: 1.2 $
 * @date    $Date: 2006/07/27 20:32:20 $
 * @author  Tomi Lamminsaari
 */

#include "CreditsViewer.h"
#include <allegro.h>
#include <almp3.h>
#include "display.h"
#include "consts.h"
#include "mp3player.h"
#include "mp3file.h"


namespace WeWantWar {

const float KStartingYCoord = 478.0;


CreditsViewer::CreditsViewer() :
  iScrollGfx(0),
  iBackgroundMusic(0)
{
}

CreditsViewer::~CreditsViewer()
{
  if ( iScrollGfx != 0 ) {
    destroy_bitmap( iScrollGfx );
  }
  delete iBackgroundMusic;
}

void CreditsViewer::showCredits()
{
  if ( initViewer() != 0 ) {
    return;
  }
  eng2d::FpsTimer* timer = eng2d::FpsTimer::getInstance();
  int frameSkip = 0;
  bool needRedraw = false;
  bool quitNow = false;
  eng2d::MP3Player::setMP3( iBackgroundMusic );
  eng2d::MP3Player::play();
  eng2d::MP3Player::volume(160);
  while ( quitNow == false ) {
    if ( key[KEY_ENTER] || key[KEY_ESC] || key[KEY_SPACE] ) {
      quitNow = true;
    }
    frameSkip = 0;
    if ( timer->updatesToGo() > 0 ) {
      do {
        iScrollPosTop -= iScrollSpeed;
        iScrollPosBottom -= iScrollSpeed;
        if ( iScrollPosBottom < 0 ) {
          iScrollPosTop = KStartingYCoord;
          iScrollPosBottom = KStartingYCoord + static_cast<float>(iScrollGfx->h);
        }
        timer->updateDone();
        frameSkip += 1;
        if ( frameSkip > 6 ) {
          timer->reset();
          break;
        }
      } while (timer->updatesToGo() > 0);
      needRedraw = true;
    }
    
    if ( needRedraw ) {
      needRedraw = false;
      clear_bitmap( eng2d::Display::buffer );
      blit( iScrollGfx, eng2d::Display::buffer, 0,0, 0,static_cast<int>(iScrollPosTop), 
            iScrollGfx->w, iScrollGfx->h );
      eng2d::Display::flip();
    }
    if ( eng2d::MP3Player::poll() == ALMP3_POLL_PLAYJUSTFINISHED ) {
      eng2d::MP3Player::play();
    }
  }
  eng2d::MP3Player::stop();
  eng2d::MP3Player::setMP3(0);
  eng2d::FpsTimer::releaseInstance( timer );
}

int CreditsViewer::initViewer()
{
  iScrollGfx = load_bitmap("gfx/levelpic/credits.bmp",0);
  if ( iScrollGfx == 0 ) {
    return -1;
  }
  iBackgroundMusic = new eng2d::MP3File("snd/music/final.mp3");
  iScrollPosTop = KStartingYCoord;
  iScrollPosBottom = KStartingYCoord + static_cast<float>( iScrollGfx->h );
  iScrollSpeed = 0.2;
  return 0;
}

} // end of namespace
